unit Repdem05;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, Forms, DBCtrls, DB, DBGrids, Buttons, DBTables, Grids,
  ExtCtrls, Printers, PrnGridR, CB_Types, CB_MFunc;

type
  Tdem05form = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    DataSource1: TDataSource;
    Panel2: TPanel;
    Query1: TQuery;
    Label1: TLabel;
    Style1: TBitBtn;
    Exit: TBitBtn;
    Query1PartNo: TFloatField;
    Query1VendorNo: TFloatField;
    Query1Description: TStringField;
    Query1OnHand: TFloatField;
    Query1OnOrder: TFloatField;
    Query1Cost: TCurrencyField;
    Query1ListPrice: TCurrencyField;
    PrintGridReport1: TPrintGridReport;
    Style2: TBitBtn;
    Style3: TBitBtn;
    Style4: TBitBtn;
    Style5: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure Style1Click(Sender: TObject);
    procedure Style2Click(Sender: TObject);
    procedure Style3Click(Sender: TObject);
    procedure Style4Click(Sender: TObject);
    procedure Style5Click(Sender: TObject);
  private
    { private declarations }
  public
  end;

var
  dem05form: Tdem05form;

implementation

{$R *.DFM}

procedure Tdem05form.FormCreate(Sender: TObject);
begin
  Query1.Open;

  PrintGridReport1.Orientation := Portrait;

  { SubTotals will be on field VenderNo}
  PrintGridReport1.SetSubTotalField(1, 'VendorNo','Vendor Number');

  { Do not total next 4 fields, but do all the rest  }
  PrintGridReport1.SetPrintTotal('PartNo', False);
  PrintGridReport1.SetPrintTotal('Cost', False);
  PrintGridReport1.SetPrintTotal('ListPrice', False);
  PrintGridReport1.SetPrintTotal('VenderNo', False);
end;

procedure Tdem05form.Style1Click(Sender: TObject);
begin
	PrintGridReport1.ReportStyle := rsColumns;
	PrintGridReport1.Execute;
end;


procedure Tdem05form.Style2Click(Sender: TObject);
begin
	PrintGridReport1.ReportStyle := rsClassic;
	PrintGridReport1.Execute;
end;

procedure Tdem05form.Style3Click(Sender: TObject);
begin
	PrintGridReport1.ReportStyle := rsThinLines;
	PrintGridReport1.Execute;
end;

procedure Tdem05form.Style4Click(Sender: TObject);
begin
	PrintGridReport1.ReportStyle := rsThickLines;
	PrintGridReport1.Execute;
end;

procedure Tdem05form.Style5Click(Sender: TObject);
begin
	PrintGridReport1.ReportStyle := rsMiddle;
	PrintGridReport1.Execute;
end;

end.